#!/bin/bash
JAR=$(find -type f -name 'paper-*.jar' -printf %f\\n | sort | head -1)
echo Found jar: ${JAR}
while true; do
    java -server -Xms1G -Xmx1G -XX:+UseG1GC -XX:+UnlockExperimentalVMOptions -XX:MaxGCPauseMillis=100 -XX:+DisableExplicitGC -XX:TargetSurvivorRatio=90 -XX:G1NewSizePercent=50 -XX:G1MaxNewSizePercent=80 -XX:G1MixedGCLiveThresholdPercent=35 -XX:+AlwaysPreTouch -XX:+ParallelRefProcEnabled -Dusing.aikars.flags=mcflags.emc.gs -jar ${JAR}
    echo "";
    for i in {5..1}; do
        echo "Server has stopped. Auto-restarting in $i seconds. Ctrl+C to cancel." && sleep 1; 
    done
    sleep 1;
    echo "Server auto restarting..."
done;
