// ==UserScript==
// @name         Export Steam Workshop Subscriptions
// @version      1.0
// @description  Adds a button to subscribed items page to easily export ALL workshop subscriptions to a simple JSON file.
// @author       Jackz
// @match        http*://steamcommunity.com/id/*/myworkshopfiles*
// @grant        GM_setClipboard
// @grant        GM_getValue
// @grant        GM_setValue
// @grant        GM_listValues
// ==/UserScript==
const ID_REGEX = new RegExp(/\?id=(\d+)/m);
(async function() {
    'use strict';
    if(getParameterByName('reset')) {
         await GM_setValue('page', null)
         await GM_setValue('items', null)
         window.location.href = UpdateQueryString("reset", null, window.location.path)
        return;
    }
    let page = await GM_getValue('page');
    let items = await GM_getValue('items');
    if(items) {
        items = JSON.parse(items)
    }else{
        items = []
    }
    const isFirstTime = page == null
    if(isFirstTime) {
        page = parseInt(getParameterByName('p')) || 1
        const forceEndPage = getParameterByName('end')
        if(forceEndPage && !isNaN(forceEndPage)) {
           await GM_setValue('lastpage', parseInt(forceEndPage))
        }else{
           const links = document.getElementsByClassName("pagelink")
           const lastPage = links.length > 0 ? parseInt(links[links.length - 1].text) : 1
           await GM_setValue('lastpage', lastPage)
        }
        await GM_setValue('items', null)
    }
    document.getElementsByClassName("rightDetailsBlock")[1].insert("<span class=\"btn_grey_steamui btn_medium\" id=\"subscribe-item\"><span>Export</span></span>")
    document.getElementById('subscribe-item').addEventListener('click', () => grabItems(page, items))
    if(!isFirstTime) {
        await grabItems(page, items)
    }
})();

function UpdateQueryString(key, value, url) {
    if (!url) url = window.location.href;
    var re = new RegExp("([?&])" + key + "=.*?(&|#|$)(.*)", "gi"),
        hash;

    if (re.test(url)) {
        if (typeof value !== 'undefined' && value !== null) {
            return url.replace(re, '$1' + key + "=" + value + '$2$3');
        }
        else {
            hash = url.split('#');
            url = hash[0].replace(re, '$1$3').replace(/(&|\?)$/, '');
            if (typeof hash[1] !== 'undefined' && hash[1] !== null) {
                url += '#' + hash[1];
            }
            return url;
        }
    }
    else {
        if (typeof value !== 'undefined' && value !== null) {
            var separator = url.indexOf('?') !== -1 ? '&' : '?';
            hash = url.split('#');
            url = hash[0] + separator + key + '=' + value;
            if (typeof hash[1] !== 'undefined' && hash[1] !== null) {
                url += '#' + hash[1];
            }
            return url;
        }
        else {
            return url;
        }
    }
}

async function grabItems(page, items) {
    for(const item of document.getElementsByClassName("workshopItemSubscriptionDetails")) {
        const match = item.outerHTML.match(ID_REGEX)
        const name = item.childNodes[1].innerText
        items.push({
            fileid: match[1],
            name: name.replace(/\s/g, '%20')
        })
    }
    let lastPage = GM_getValue('lastpage')
    if(page >= lastPage) {
        await GM_setClipboard(items, "text");
        await GM_setValue('page', null)
        await GM_setValue('items', null)
        const appid = getParameterByName("appid")
        var a = document.createElement("a");
        a.href = "data:application/json," + JSON.stringify({
            items,
            meta: {
                timestamp: Date.now(),
                appid
            }
        });  //content
        a.download = "workshop_subscriptions_" + appid + ".json";            //file name
        a.click();
        return;
    }else{
        await GM_setValue('page', page + 1)
        await GM_setValue('items', JSON.stringify(items))
        const url = UpdateQueryString("p", page+1, window.location.path)
        window.location.href = url
    }
}

function getParameterByName(name, url = window.location.href) {
    name = name.replace(/[\[\]]/g, '\\$&');
    var regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)'),
        results = regex.exec(url);
    if (!results) return null;
    if (!results[2]) return '';
    return decodeURIComponent(results[2].replace(/\+/g, ' '));
}