// ==UserScript==
// @name         Export Blocked Steam Players
// @version      1.0
// @description  Adds a button to export all blocked players
// @author       Jackz
// @match        http*://steamcommunity.com/id/*/friends/blocked
// @grant        GM_setClipboard
// @grant        GM_getValue
// @grant        GM_setValue
// @grant        GM_listValues
// @downloadURL  https://gist.githubusercontent.com/Jackzmc/1cd07cc9e1401ef78c87d45f6450ae84/raw/517541eeaee64f8864f899c4a91d07458389f8f8/export_blocked.js
// @updateURL    https://gist.githubusercontent.com/Jackzmc/1cd07cc9e1401ef78c87d45f6450ae84/raw/517541eeaee64f8864f899c4a91d07458389f8f8/export_blocked.js
// ==/UserScript==
(async function() {
    document.getElementsByClassName("title_bar")[0].insert("<div class=\"btnv6_blue_hoverfade btn_small btn_uppercase\" id=\"export-btn\">Export</div>&nbsp;")
    document.getElementById('export-btn').addEventListener('click', () => {
        const items = [];
        for(const item of document.getElementsByClassName("selectable")) {
            items.push(item.attributes['data-steamid'].textContent)
        }
        GM_setClipboard(JSON.stringify(items), "text");
        var a = document.createElement("a");
        a.href = "data:application/json," + JSON.stringify(items);
        a.download = "banned_users.json";
        a.click();
    })
})();