const fs = require('fs')
const MODEL_NAMES = {
    2627665880: 'Online Female'
}

fs.readFile('./outfit.json', 'utf-8', (err, data) => {
    if(err) {
        console.error(err)
        process.exit(1)
    }
    const { Outfit, Accessories, Clothing } = JSON.parse(data)
    let object = {}
    if(!Outfit) {
        //some other format?
        object = {
            Model: 'Online Female',
            Head: 0,
            'Head Variation': 0,
            Mask: Clothing['Mask Drawable'],
            'Mask Variation': Clothing['Mask Texture'],
            Hair: Clothing['Hair Drawable'],
            'Hair Variation': Clothing['Hair Texture'],
            Top: Clothing['Torso Drawable'],
            'Top Variation': Clothing['Torso Texture'],
            'Top 2': Clothing['Torso 2 Drawable'],
            'Top 2 Variation': Clothing['Torso 2 Texture'],
            'Top 3': Clothing['Undershirt Drawable'],
            'Top 3 Variation': Clothing['Undershirt Texture'],
            'Gloves / Torso': 0,
            'Gloves / Torso Variation': 0,
            'Parachute / Bag': 0,
            'Parachute / Bag Variation': 0,
            Pants: Clothing['Leg Drawable'],
            'Pants Variation': Clothing['Leg Texture'],
            Shoes: Clothing['Shoes Drawable'],
            'Shoes Variation': Clothing['Shoes Texture'],
            Accessories: Clothing['Accessories Drawable'],
            'Accessories Variation': Clothing['Accessories Texture'],
            Decals: 0,
            'Decals Variation': 0,
            Hat: Accessories['Hats Drawable'],
            'Hat Variation': Accessories['Hats Texture'],
            Glasses: Accessories['Glasses Drawable'],
            'Glasses Variation': Accessories['Glasses Texture'],
            Earwear: Accessories['Ears Drawable'],
            'Earwear Variation': Accessories['Ears Texture'],
            Watch: Accessories['Watches Drawable'],
            'Watch Variation': Accessories['Watches Texture'],
            Bracelet: Accessories['Bracelets Drawable'],
            'Bracelet Variation': Accessories['Bracelets Texture']
        }
    }else{
        //paragon format
    }
    let text = ""
    for(const key in object) {
        text += `${key}: ${object[key]}\n`
    }
    fs.writeFile('./outfit.txt', text, (err) => {
        if(err) {
            console.error(err)
            process.exit(1)
        }
    })
})