#!/bin/bash
APPID=222860
STEAMCMD_PATH=~/steamcmd/steamcmd.sh
if test -f "update.lock"; then
	echo "update.lock found, cancelling"
	exit 1
fi
touch update.lock
trap '{ rm -f -- "update.lock"; }' EXIT
# Due to some new steamcmd bugs, you cannot install the game except for windows. Valve doesn't seem like they will fix this
# So instead, we force it to download windows files, then we are able to download the linux version afterwards
"$STEAMCMD_PATH" +@sSteamCmdForcePlatformType windows +force_install_dir $PWD +login anonymous +app_update $APPID validate +quit
"$STEAMCMD_PATH" +@sSteamCmdForcePlatformType linux +force_install_dir $PWD +login anonymous +app_update $APPID validate +quit
rm update.lock