# initially generated by chatgpt
import vdf

def extract_launch_options(filepath):
    with open(filepath, 'r', encoding='utf-8') as f:
        data = vdf.load(f)

    results = []

    def walk(node):
        for key, val in node.items():
            if isinstance(val, dict):
                if key.isdigit() and "LaunchOptions" in val:
                    print(f"[{key}] {val['LaunchOptions']}")
                walk(val)

    walk(data)
    return results

if __name__ == "__main__":
    import argparse

    parser = argparse.ArgumentParser("extract")
    parser.add_argument("filepath", help="the path to the VDF file to extract")
    args = parser.parse_args()

    extract_launch_options(args.filepath)