# was generated with chatgpt
import vdf
import json

def extract_launch_options(filepath):
    with open(filepath, 'r', encoding='utf-8') as f:
        data = vdf.load(f)

    results = []

    def walk(node):
        for key, val in node.items():
            if isinstance(val, dict):
                if key.isdigit() and "LaunchOptions" in val:
                    results.append({
                        "appid": key,
                        "LaunchOptions": val["LaunchOptions"]
                    })
                walk(val)

    walk(data)
    return results

if __name__ == "__main__":
    import argparse

    parser = argparse.ArgumentParser("extract")
    parser.add_argument("filepath", help="the path to the VDF file to extract")
    args = parser.parse_args()

    print(json.dumps(extract_launch_options(args.filepath), indent=2))
