#!/bin/bash
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
if [[ "$#" -lt 1 ]]; then #if less than 1
 echo "Usage: ./download.sh <youtube url> [name of file] "
 exit 2
fi
if [[ "$#" -ne 2 ]]; then
 echo Downloading $1
 OUTPUT="$DIR/%(id)s.%(ext)s"
else
 echo Downloading $1 as $2
 OUTPUT="$DIR/$2.%(ext)s"
fi
youtube-dl -f 'bestaudio[ext=m4a]' "$1" --output $OUTPUT --add-metadata --embed-thumbnail --no-playlist
