const fs = require('fs')

let version = "2.0"

fs.readFile('./animations.txt', 'utf-8', (err, data) => {
    if(err) {
        console.error(err)
        process.exit(1)
    }
    const animations = []
    const lines = data.trim().split("\n")
    lines.forEach(line => {
        const [group, anim] = line.split(" ")
        animations.push({group, anim})
    })
    const animLine = animations.map(a => `\t{ "${a.group}", "${a.anim}" },`).join("\n")
    fs.writeFile('./animations.lua', `ANIMATIONS_INDEX_VERSION = "${version}"\nANIMATIONS = {\n${animLine}\n}`, (err) => {
        if(err) console.error('write err', err)
    })
})